package gov.va.med.mhv.calendar.dto;

import gov.va.med.mhv.calendar.enums.ProviderTypeEnumeration;

import java.io.Serializable;

public class HealthCareProviderDTO implements Serializable {

	private static final long serialVersionUID = 1L;

	
	private Long healthCareProviderId;
	private String firstName;
	private String lastName;
	private String providerType;// Primary, Specialist, Dentist, Eye, Other
								// Clinician
	private String otherClinician;
	private String workPhone;
	private String workPhoneExt;
	private String emailAddress;
	private String comments;
	private Long userProfileId;

	public HealthCareProviderDTO() {
	}
	
	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getProviderType() {
		return providerType;
	}

	public void setProviderType(String providerType) {
		this.providerType = providerType;
	}

	public String getOtherClinician() {
		return otherClinician;
	}

	public void setOtherClinician(String otherClinician) {
		this.otherClinician = otherClinician;
	}

	
	public Long getHealthCareProviderId() {
		return healthCareProviderId;
	}

	public void setHealthCareProviderId(Long healthCareProviderId) {
		this.healthCareProviderId = healthCareProviderId;
	}

	public String getWorkPhone() {
		return workPhone;
	}

	public void setWorkPhone(String workPhone) {
		this.workPhone = workPhone;
	}

	public String getWorkPhoneExt() {
		return workPhoneExt;
	}

	public void setWorkPhoneExt(String workPhoneExt) {
		this.workPhoneExt = workPhoneExt;
	}

	public String getEmailAddress() {
		return emailAddress;
	}

	public void setEmailAddress(String emailAddress) {
		this.emailAddress = emailAddress;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public Long getUserProfileId() {
		return userProfileId;
	}

	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}
	
	public ProviderTypeEnumeration[] getProviderTypes() {
		return ProviderTypeEnumeration.values();
	}

	@Override
	public String toString() {
		return "HealthCareProviderDTO [healthCareProviderId=" + healthCareProviderId + ", firstName="
				+ firstName + ", lastName=" + lastName + ", providerType=" + providerType + ", otherClinician=" + otherClinician
				+ ", workPhone=" + workPhone + ", workPhoneExt=" + workPhoneExt + ", emailAddress=" + emailAddress + ", comments="
				+ comments + ", userProfileId=" + userProfileId + "]";
	}
	
	
}